---
title: "OT"
author: "Jean Feydy"
institute: ""
topic: ""
theme: "metropolis"
colortheme:
fonttheme:
fontsize: 11pt
linkcolor: black
urlcolor: blue
linkstyle: bold
aspectratio: 169
titlegraphic: 
logo:
date:
section-titles: false
toc: false
---


## My main motivation

Develop **robust and efficient** software that $\BR{stimulates}$ **other researchers**:

1. Speed up $\BR{geometric}$ **machine learning** on GPUs: \
   $\Longrightarrow~~$ **pyKeOps** library for distance and kernel matrices, 950k+ downloads.

2. Scale up $\BR{pharmacovigilance}$ to the full French population: \
   $\Longrightarrow~~$ **survivalGPU**, a fast re-implementation of the R survival package.

3. Ease access to modern statistical $\BR{shape analysis}$: \
   $\Longrightarrow~~$ **GeomLoss**, truly scalable optimal transport in Python. \
   $\Longrightarrow~~$ **scikit-shapes**, beta release available soon.


## Speed and consistency with diverse data structures


`\begin{center}`{=latex}

![](images/encoding/L5_vertebra_encoding.pdf){height=7cm}

`\end{center}`{=latex}


## Today’s talk

**Graphics Processing Units** provide a **x1,000 speed-up** for parallel computations.

$\BR{Bruteforce computing}$ $~ ~\neq~ ~$ Switch **off** your brain. \
**Bruteforce computing** $~ ~= ~ ~$ Modelling $\BR{freedom}$!


Two examples, enabled by PyTorch ($\simeq$ Matlab, for GPUs) and my "KeOps" extension:

1. A phase-field model for the **synthesis of biological** $\BR{microstructures}$. \

2. A simple framework to simulate **incompressible biological** $\BR{cells}$. \



# Biological microstructures


## Memories from the Covid lockdown...

```{=latex}
\vspace*{1cm}
\centerline{
\begin{tabular}{c}
\includegraphics[height=5cm]{images/sourires/medaillons/Anna_2.png}\\
\textbf{Anna Song} \\
Francis Crick Institute, \\
now at Dassault Systèmes.
\end{tabular}
}
```


## Biological motivation

`\vspace*{.5cm}\begin{center}`{=latex}
![](images/curvature/curvatubes_motivation.png){height=95%}
`\end{center}`{=latex}



## Curvature of a 2D surface

`\begin{center}`{=latex}
![](images/curvature/principal_curvatures.png){height=95%}
`\end{center}`{=latex}


## Minimal surfaces in physics

`\begin{center}`{=latex}
![](images/biology/soap.png){height=4cm}
`\end{center}`{=latex}

Soap bubbles minimize:
$$\mathrm{area(\mathcal{S})} = \int_{\mathcal{S}} 1 \, dA $$
under constant volume, or with boundary conditions. \
They correspond to minimal surfaces with $~~H = \kappa_1 + \kappa_2 = 0~~$ in cases 2 and 3.


## Minimal surfaces in biology

`\begin{center}`{=latex}
![](images/biology/RBC.png){height=4cm}
`\end{center}`{=latex}

Red blood cells minimize:
$$\mathrm{Helfrich}(\mathcal{S}) = \int_{\mathcal{S}} (H-H_0)^2 \, dA$$
or a variant of this energy, under constant volume.


## The curvatubes model `\cite{song2022generation}`{=latex}

`\begin{center}`{=latex}
![](images/biology/curvatubes.png){height=4cm}
`\end{center}`{=latex}

Curvatubes minimize:
$$F(\mathcal{S}) = \int_{\mathcal{S}} p(\kappa_1,\kappa_2) \, dA$$
under constant volume, where: 
$$p(\kappa_1,\kappa_2) = a_{2,0} \, \kappa_1^2 + a_{1,1} \, \kappa_1 \kappa_2 + a_{0,2} \, \kappa_2^2 + a_{1,0} \,\kappa_1 + a_{0,1} \,\kappa_2 + a_{0,0}~.$$


## Under the hood: a phase-field formulation

`\vspace*{-.3cm}\begin{center}`{=latex}
![](images/curvature/curvatubes_phase_field.png){height=95%}
`\end{center}`{=latex}


## Texture generation via gradient descent on a convolutional energy

`\vspace*{0.0cm}\begin{center}`{=latex}
![](images/curvature/curvatubes_generation.png){height=95%}
`\end{center}`{=latex}


## A surprisingly expressive model

`\begin{center}\vspace*{.5cm}`{=latex}
![](images/biology/simus.png){width=100%}
`\end{center}`{=latex}



## PyTorch and GPUs go **way beyond** deep learning research

`\begin{center}`{=latex}
![](images/biology/surface_phase.png){height=3.5cm}
`\end{center}`{=latex}

An **inspiring** model:

- **Surface** energy $~\to~$ $\BR{convolutional}$ **volumetric** loss function (phase-field).
- Start with **white noise** (texture generation) and minimize with **gradient descent**.
- Implemented on GPU with $\BR{PyTorch}$.

`\begin{center}`{=latex}
$\Longrightarrow$ Combines **maths** + **GPU** computing + **imaging** data
`\end{center}`{=latex}


# Incompressible particles

## Two very talented colleagues

```{=latex}
\vspace*{1cm}
\centerline{
\begin{tabular}{c@{\qquad\qquad}c}
\includegraphics[height=5cm]{images/sourires/medaillons/Maciej_2.png}
&
\includegraphics[height=5cm]{images/sourires/medaillons/Antoine_2.png}\\
\textbf{Maciej Buze}
&
\textbf{Antoine Diez} \\
Lancaster University
&
RIKEN iTHEMS, Tokyo
\end{tabular}
}
```

## GPU programming 101: the N-body problem `\cite{galaxy}`{=latex}

`\begin{center}`{=latex}

![](images/particles/galaxy_s.jpg){height=90%}

`\end{center}`{=latex}


## Coding a simple fluid simulation is now a matter of hours `\cite{coding_adventure}`{=latex}

`\begin{center}`{=latex}

![](images/particles/coding_adventure.jpg){height=90%}

`\end{center}`{=latex}


## The material point method: Disney's Frozen `\cite{stomakhin2013material}`{=latex}

`\begin{center}`{=latex}

![](images/particles/frozen.png){height=90%}

`\end{center}`{=latex}



## How can we enforce a volume preservation constraint? `\cite{power_particles_in_cell}`{=latex}

`\begin{center}`{=latex}

![](images/particles/clumps_and_voids.png){height=90%}

`\end{center}`{=latex}



## Use power diagrams $~$ i.e. $~$  semi-discrete optimal transport


`\begin{center}`{=latex}

![](images/particles/laguerre_cells.pdf){height=90%}

`\end{center}`{=latex}


- The $f_i$'s maximize the dual objective $~\sum_{i=1}^N v_i f_i + \int_{y\in\Omega} \min_{i=0}^N [\,c_i(y) - f_i\,] \,\text{d}y$.
- **Optimality** conditions $~\Longleftrightarrow~$ $\text{Vol}(\text{Cell}_i) = v_i$.
- To **compute the cells**, the objective and its gradient:
   - If $c_i(y) = \|y - x_i\|^2$ for all cells, use a clever **grid-free** algorithm.
   - Otherwise, just use $\BR{KeOps}$.


## Power plastics `\cite{power_plastics}`{=latex}

`\begin{center}`{=latex}

![](images/particles/power_plastics_1.png){height=90%}

`\end{center}`{=latex}

## Power plastics `\cite{power_plastics}`{=latex} -- without the eye candy

`\begin{center}\vspace*{1cm}`{=latex}

![](images/particles/power_plastics_2.png){height=90%}

`\end{center}`{=latex}



## Main numerical ingredients

These simulations alternate between:

1. **Moving the particles** according to your favorite N-body model.
   
2. Computing Laguerre `\BR{cells}`{=latex} with the **correct volumes**:
   - (Multiscale) Sinkhorn for tolerance $>$ 5\%. 
   - (Quasi-)Newton for tolerance $<$ 1\%.
  
3. **Correcting** the particle positions to enforce the volume-preservation constraint:
   - Jump to the centroid of the cell.
   - Or add a spring for smoother trajectories.

`\begin{center}`{=latex}
See e.g. Thomas Gallouët for a rigorous analysis with Mérigot, Lévy, etc. \
**But today:** new applications with `\BR{custom cost functions}`{=latex} (thanks KeOps).
`\end{center}`{=latex}


## Anisotropic power diagrams let us model polycrystalline metals `\cite{apd_maciej_2024}`{=latex}

`\vspace*{.5cm}`{=latex}

::: columns
:::: {.column width=32%}

`\begin{center}`{=latex}

![](images/particles/APD_1.png){height=4.4cm}

Ellipsoids.
`\end{center}`{=latex}

::::

:::: {.column width=32%}

`\begin{center}`{=latex}

![](images/particles/APD_2.png){height=4.4cm}

Pixel cells.

`\end{center}`{=latex}

::::


:::: {.column width=32%}

`\begin{center}`{=latex}

![](images/particles/APD_3.png){height=4.4cm}

5,000 crystals in 3D.

`\end{center}`{=latex}

::::
:::


## Fit to real EBSD scan of low-carbon steel `\cite{apd_maciej_2024}`{=latex}


`\vspace*{.5cm}`{=latex}

::: columns

:::: {.column width=32%}

`\begin{center}`{=latex}

![](images/particles/steel_scan.png){height=5cm}

Data from Tata steel.

`\end{center}`{=latex}


::::

:::: {.column width=32%}

`\begin{center}`{=latex}

![](images/particles/steel_model.png){height=5cm}

Our APD model.

`\end{center}`{=latex}

::::


:::: {.column width=32%}

`\begin{center}`{=latex}

![](images/particles/steel_synthetic.png){height=5cm}

New synthetic image.

`\end{center}`{=latex}

::::
:::


`\begin{center}`{=latex}
We can generate new, realistic 3D images with **prescribed properties** in seconds.
`\end{center}`{=latex}



## Change the cost function to simulate hard (blue) and soft (orange) cells `\cite{diez2024optimal}`{=latex}

`\vspace*{-.1cm}`{=latex}

::: columns

:::: {.column width=48%}

`\begin{center}`{=latex}

![](images/particles/iceshot_cube_1.png){height=6.5cm}

The **raw** 100x100x100 pixel grid...

`\end{center}`{=latex}

::::


:::: {.column width=48%}

`\begin{center}`{=latex}

![](images/particles/iceshot_cube_2.png){height=6.5cm}

with some Hollywood **makeup**.

`\end{center}`{=latex}

::::
:::


## Let's visit Antoine's website

```{=latex}
\begin{center}

{\Large $\Longrightarrow$ \url{https://iceshot.readthedocs.io} $\Longleftarrow$}

\end{center}
```

## Run-and-tumble motion `\cite{diez2024optimal}`{=latex}


`\vspace*{.3cm}`{=latex}

::: columns

:::: {.column width=49%}

`\begin{center}`{=latex}

![](images/particles/tumble_disk.png){height=6cm}

2D disk.

`\end{center}`{=latex}

::::


:::: {.column width=50%}

`\begin{center}`{=latex}

![](images/particles/tumble_bricks.png){height=6cm}

3D cube.

`\end{center}`{=latex}

::::
:::



## Fire alarm! `\cite{diez2024optimal}`{=latex}


`\vspace*{.5cm}`{=latex}

::: columns

:::: {.column width=48%}

`\begin{center}`{=latex}

![](images/particles/evacuation_1.png){height=6cm}

Hard particles `\textcolor{red}{\textbf{burn}}`{=latex}.

`\end{center}`{=latex}

::::


:::: {.column width=48%}

`\begin{center}`{=latex}

![](images/particles/evacuation_2.png){height=6cm}

Soft particles **escape**.

`\end{center}`{=latex}

::::
:::


## Self-organizing swarms of blind, incompressible swimmers `\cite{diez2024optimal}`{=latex}


`\vspace*{.5cm}`{=latex}

`\begin{center}`{=latex}

![](images/particles/swarm.png){height=90%}

`\end{center}`{=latex}



## Self-organizing swarms of blind, incompressible swimmers `\cite{diez2024optimal}`{=latex}


`\vspace*{.5cm}`{=latex}

::: columns

:::: {.column width=32%}

`\begin{center}`{=latex}

![](images/particles/swarm_t0.png){height=5cm}

$t = 0$

`\end{center}`{=latex}


::::

:::: {.column width=32%}

`\begin{center}`{=latex}

![](images/particles/swarm_t400.png){height=5cm}

$t=4$

`\end{center}`{=latex}

::::


:::: {.column width=32%}

`\begin{center}`{=latex}

![](images/particles/swarm_t3000.png){height=5cm}

$t = 30$

`\end{center}`{=latex}

::::
:::


`\begin{center}`{=latex}
**Order emerges** out of blind collisions and re-alignments.
`\end{center}`{=latex}



## Surface tension `\cite{diez2024optimal}`{=latex}

`\begin{center}`{=latex}

![](images/particles/surface_tensions.png){height=90%}

`\end{center}`{=latex}

## Surface tension `\cite{diez2024optimal}`{=latex} -- playing with the energy parameters

`\begin{center}`{=latex}

![](images/particles/surface_tensions_2.png){height=90%}

`\end{center}`{=latex}







# Conclusion

## Key points

- **"Video-game physics"** is great for modelling: \
  $\longrightarrow~~$ `\BR{Expressive}`{=latex}, real-time simulations that you can implement \
  $\phantom{\longrightarrow}~~~$ without being a Finite Elements guru: XPBD, DiffPD, Taichi...

- $\BR{GPUs}$ are more **versatile** than you think. \
  $\longrightarrow~~$ Ongoing work to provide **fast GPU backends** to researchers, \
  $\phantom{\longrightarrow}~~~$ going beyond what Google and Facebook are ready to pay for. \

`\begin{center}`{=latex}
**Target** for scientific Python: **interactive, web-based** simulations à la ShaderToy.
`\end{center}`{=latex}


## Documentation and tutorials are available online

```{=latex}
\begin{center}
$\Longrightarrow$\qquad \url{www.kernel-operations.io}\qquad $\Longleftarrow$
\vspace*{.15cm}

\includegraphics[width=.5\linewidth,frame]{images/geometric_data_analysis.png}

%\vspace*{.15cm}

\url{www.jeanfeydy.com/geometric_data_analysis.pdf}
\end{center}

```

## Documentation and tutorials are available online

```{=latex}
\begin{center}
$\Longrightarrow$\qquad \url{shape-analysis.github.io}\qquad $\Longleftarrow$
\vspace*{.15cm}

\includegraphics[width=.75\linewidth,frame]{images/shape_analysis.png}

%\vspace*{.15cm}

Monthly seminar, videos on YouTube.
\end{center}

```


# References


