#!/bin/sh

DATE_COVER=$(date "+%d %B %Y")

SOURCE_FORMAT="markdown_strict\
+pipe_tables\
+backtick_code_blocks\
+auto_identifiers\
+strikeout\
+yaml_metadata_block\
+implicit_figures\
+all_symbols_escapable\
+link_attributes\
+smart\
+fenced_divs\
+raw_attribute\
+tex_math_dollars\
+escaped_line_breaks\
+latex_macros"

# /usr/bin/pandoc -s --dpi=300 --slide-level 2 --toc --listings --shift-heading-level=0 --columns=50 --data-dir=. --template default_mod.tex --pdf-engine lualatex --pdf-engine-opt=-shell-escape --pdf-engine-opt=--output-directory=temp -f "$SOURCE_FORMAT" -M date="$DATE_COVER" -V classoption:aspectratio=169 --verbose --log=log.txt -V lang=fr -t beamer slides.md -o slides.pdf
 
/usr/bin/pandoc -s --dpi=300 --slide-level 2 --toc --citeproc  --bibliography biblio.bib --listings --shift-heading-level=0 --columns=50 --data-dir=. --template default_mod.tex  -f "$SOURCE_FORMAT" -V classoption:aspectratio=169 --verbose --log=log.txt -V lang=en-GB -t beamer slides.md -o slides.tex

lualatex -shell-escape slides.tex
#bibtex slides
#lualatex -shell-escape slides.tex

