---
title: "Quels logiciels pour l'apprentissage en anatomie ?"
author: "Jean Feydy"
institute: ""
topic: ""
theme: "metropolis"
colortheme:
fonttheme:
fontsize: 11pt
linkcolor: black
urlcolor: blue
linkstyle: bold
aspectratio: 169
titlegraphic: 
logo:
date:
section-titles: false
toc: false
---



## HeKA : une équipe à l'interface pour la santé publique

`\begin{center}`{=latex}

![](images/HeKA.pdf){height=7cm}

`\end{center}`{=latex}

## PariSanté Campus

`\vspace*{.5cm}`{=latex}

::: columns
:::: {.column width=40%}
`\begin{center}`{=latex}
![](images/Curie_PSC.png){height=4.5cm}

`\end{center}`{=latex}
::::
:::: {.column width=60%}
`\begin{center}`{=latex}
![](images/PariSanteCampus.jpg){height=4.5cm}

`\end{center}`{=latex}
::::
:::

## L'anatomie numérique

`\vspace*{.5cm}`{=latex}

![](images/pipeline.png){ width=100% }

`\vspace*{.25cm}`{=latex}


`\begin{center}`{=latex}
Comment passer d'un **tableau de nombres** à une représentation $\BR{intelligible}$ ?
`\end{center}`{=latex}


## Aujourd'hui : un état des lieux sur nos outils logiciels

 \
**1.** Qu'est-ce qu'une **image** ?

 \
**2.** Quels **logiciels pour l'IA** ?

 \
**3.** $\BR{Complétons}$ notre boîte à outils.



# Qu'est-ce qu'une image ?


## Une image : trois niveaux d'analyse `\cite{heart_raw, heart_pop}`{=latex}

```{=latex}
\vspace{-.43cm}
\begin{align*}
  \onslide<2->{ \text{1. Pixels} }&&
  \onslide<3->{ \text{2. Anatomie} } &&
  \onslide<5->{ \text{3. Fonction} }
\end{align*}

\begin{figure}
  \centering %
	\only<1-2>{ \includegraphics[height=.7\textheight,width=\textwidth]{images/hearts/heart_raw.png} }%
	\only<3>{ \includegraphics[height=.7\textheight,width=\textwidth]{images/hearts/heart_segmented.png} }%
	\only<4>{ \includegraphics[height=.7\textheight,width=\textwidth]{images/hearts/dev_coeurs_2.png} }%
	\only<5>{ \includegraphics[height=.7\textheight,width=\textwidth]{images/hearts/hearts_0.png} }%
	\only<6>{ \includegraphics[height=.7\textheight,width=\textwidth]{images/hearts/hearts_1.png} }%
	\only<7>{ \includegraphics[height=.7\textheight,width=\textwidth]{images/hearts/hearts_2.png} }%
	\only<8>{ \includegraphics[height=.7\textheight,width=\textwidth]{images/hearts/hearts_3.png} }%
	\only<9>{ \includegraphics[height=.7\textheight,width=\textwidth]{images/hearts/hearts_4.png} }%
	\only<10>{ \includegraphics[height=.7\textheight,width=\textwidth]{images/hearts/hearts_5.png} }%
	\only<11>{ \includegraphics[height=.7\textheight,width=\textwidth]{images/hearts/hearts_6.png} }%
	\only<12>{ \includegraphics[height=.7\textheight,width=\textwidth]{images/hearts/hearts_7.png} }%
	\only<13>{ \includegraphics[height=.7\textheight,width=\textwidth]{images/hearts/hearts_8.png} }%
	\only<14>{ \includegraphics[height=.7\textheight,width=\textwidth]{images/hearts/hearts_9.png} }%
	\only<15>{ \includegraphics[height=.7\textheight,width=\textwidth]{images/hearts/hearts_0.png} }%
	\only<16->{ 
    \includegraphics[height=.55\textheight]{images/heart_models.png}
    \begin{center}
    En simplifiant beaucoup, chaque niveau de description\\
    correspond à une manière de \textbf{regrouper les pixels}.
    \end{center}
    }%
\end{figure}
```



## 1er niveau : grille de pixels

```{=latex}
		\begin{columns}[t]
		\begin{column}{.5\linewidth}

		\begin{center}
			\vspace*{.4cm}

			\includegraphics[width=.8\linewidth]{images/bitmap/mini_bitmap.png}%

			Tableau $N_x \times N_y \times N_z$ de pixels.
		\end{center}
			
		\end{column}
		\begin{column}{.45\linewidth}

      \vspace*{.5cm}

			Images et volumes \textbf{bitmap} :
			\begin{itemize}
				\item \texttt{.bmp}, \texttt{.png}, \texttt{.jpg} 
				\item Standard en \textbf{radiologie}.\\[.5cm]
				\item[$+$] Structure mémoire ordonnée.
				\item[$+$] Voisinages explicites.
				\item[$+$] \textbf{Convolutions} rapides. \\[.5cm]
				\item[$\rightarrow$] Analyse de \textbf{texture}.
				\item[$\rightarrow$] \textbf{Segmentation} des tissus.
				\item[$\rightarrow$] \textbf{Détection} de motifs. 
			\end{itemize}
		\end{column}
	\end{columns}	
```


## 2ème niveau : nuages de points et surfaces 3D `\cite{heart_raw}`{=latex}

```{=latex}
\begin{columns}[t]
  \begin{column}{.5\linewidth}

  \begin{center}
    \vspace*{1cm}

    \includegraphics[width=.8\linewidth]{images/bitmap/mesh.png}%

    Tableau $N_{\text{points}} \times 3$ \\
    de coordonnées $(x,y,z)$.
  \end{center}
    
  \end{column}
  \begin{column}{.45\linewidth}

    \vspace*{.5cm}

    \textbf{Nuages de points} ($\pm$ triangles) :
    \begin{itemize}
      \item \texttt{.svg}
      \item Standard pour le \textbf{jeu vidéo}.\\[.5cm]
      \item[$+$] Représentation compacte.
      \item[$+$] Géométrie de haute précision.
      \item[$+$] \textbf{Facile à déformer}. \\[.5cm]
      \item[$\rightarrow$] \textbf{Visualisation 3D}.
      \item[$\rightarrow$] \textbf{Atlas} anatomiques.
      \item[$\rightarrow$] Analyse des \textbf{formes}.
    \end{itemize}
  \end{column}
\end{columns}	
```

## 3ème niveau : modèle biomécanique ou physiologique `\cite{heart_pop}`{=latex}

```{=latex}
\begin{columns}[t]
  \begin{column}{.5\linewidth}

  \begin{center}
    \vspace*{.5cm}

    \includegraphics[height=5cm]{images/bitmap/hearts_1.png}%

    Mesh volumique, \\graphe d'interactions.
  \end{center}
    
  \end{column}
  \begin{column}{.45\linewidth}

    \vspace*{.5cm}

    \textbf{Modèle physique, biologique} :
    \begin{itemize}
      \item Éléments finis, réseaux.
      \item Standard pour la \textbf{CAO}.\\[.5cm]
      \item[$+$] \textbf{Connaissance} a priori.
      \item[$+$] \textbf{Robuste} au bruit.
      \item[$+$] Comportement \textbf{réaliste}. \\[.5cm]
      \item[$\rightarrow$] Interprétation \textbf{physiologique}.
      \item[$\rightarrow$] \textbf{Inférer} ce qui est invisible.
      \item[$\rightarrow$] \textbf{Simuler} une intervention.
    \end{itemize}
  \end{column}
\end{columns}	
```


## Forces et faiblesses de ces représentations

Comment chercher les **voisins** d'un point de l'espace ?

- Sur une **grille** : $\textcolor{green!60!black}{\text{immédiat}}$.
- Avec $N$ **points** $(x,y,z)$ : $\text{\textcolor{red!60!black}{calcul}}$ de $N$ distances, ou $\text{\textcolor{red!60!black}{construction}}$ d'un arbre.


 \
Comment faire **pivoter** un organe de 10° ?

- Sur une **grille** : $\text{\textcolor{red!60!black}{artefacts}}$, perte de détails, transferts de mémoire.
- Avec $N$ **points** $(x,y,z)$ : arithmétique $\text{\textcolor{green!60!black}{simple}}$ sur les coordonnées.

`\begin{center} ~\\`{=latex}
**Efficacité** numérique $\Longleftrightarrow$ Entraînement sur de $\BR{grandes bases de données}$.
`\end{center}`{=latex}


## Bilan

En imagerie médicale, on peut travailler avec:

- Une **grille de pixels** 2D ou 3D.
- Un **tableau de coordonnées** $(x,y,z)$.
- Un **réseau d'interactions** complexes.
- Les trois à la fois!

```{=latex}
\begin{center}
~\\
Dans tous les cas, il s'agit de définir une
grande \BR{formule structurée} :
\begin{align*}
  \text{image} \xrightarrow{~~~F~~~} F\,(\text{image}) \simeq \text{diagnostic}
\end{align*}

On parle d'\textbf{architecture} de calcul paramétrique\\
$\simeq$ \textbf{modèle} à fitter $\simeq$ \textbf{réseau} à entraîner.
\end{center}
```

# Quels outils logiciels pour l'IA ?

## Le matériel est au cœur de la "révolution de l'IA"

L'**imagerie** et l'**apprentissage** automatique sont étudiés depuis des **décennies**. \
**Percée** en 2010-15 : utiliser des $\BR{PlayStations}$ pour faire de la $\BR{science}$ est devenu **facile**.

::: columns
:::: {.column width=70%}

 \
 \
Effort de recherche à tous les niveaux vers:

- Un **matériel** toujours plus puissant.
- Des **bibliothèques** toujours plus souples.
- Des **modèles** toujours plus pertinents.

 \
 \
Résultats **spectaculaires** obtenus dans quelques domaines \
$\Longrightarrow~~$ grands $\BR{investissements}$ publics et privés.

::::
:::: {.column width=30%}
`\begin{center}`{=latex}

![](images/ampere.jpg){height=4cm}

 \
**7,000 cœurs** sur un GPU.

`\end{center}`{=latex}
::::
:::



## Pour aller au-delà des prototypes, une suite logicielle complète est nécessaire

```{=latex}
\vspace*{.5cm}

\centerline{
\begin{tabular}{c@{~~}c@{~~$+$~~}c@{~~$+$~~}c@{~~$\Longrightarrow$~~}c}
\BR{Graphisme~:} & \textcolor{red!50!black}{Imprimante} & \textcolor{red!50!black}{Driver} & \BR{Photoshop} & \textcolor{red!50!black}{Dessins} \\[1cm]
\makecell{\textbf{Données}\\\textbf{tabulaires~:}} & GPU & \textbf{cuBLAS} & \makecell{ \textbf{PyTorch} \\ TensorFlow } 
& \makecell{Réseaux de neurones \\ \textbf{``classiques''}} \\[1cm]
\makecell{\textbf{Grilles}\\\textbf{de pixels~:}} & GPU & \textbf{cuDNN} & \makecell{ PyTorch \\ TensorFlow } 
& \makecell{Réseaux de neurones \\ \textbf{convolutifs}} \\[1cm]
\makecell{\textbf{Nuages de points}\\\textbf{et graphes~:}} & GPU & \textbf{CUDA} & 
\BR{??}
& \makecell{Réseaux de neurones \\ \textbf{géométriques}}
\end{tabular}
}
```


# Complétons notre boîte à outils

## Comment développe-t-on un logiciel d'imagerie médicale ?

**2000--2010 :** bases de code $\BR{``monolithiques''}$ en C++

- Le C++ est incontournable pour les performances en 3D.
- **Difficile à maintenir** et à faire **évoluer**.


**2010--2020 :** développement $\BR{modulaire}$ en Python/C++

- **Appeler une bibliothèque C++** depuis Python est devenu facile.
- Alliance de la souplesse du Python et des performances du C++.
- Échanges entre les communautés, **facilité d'adoption** par les nouveaux venus.


**2020--2030 :** $\BR{dépasser les limites des bibliothèques}$ C++ existantes

- **Générer du code C++** pour GPU et le compiler à la volée est devenu facile.
- Maintenir une extension de PyTorch "optimisée pour ..." devient raisonnable.


## Exemple : la bibliothèque KeOps `\texttt{~~www.kernel-operations.io}`{=latex}

`\begin{center}`{=latex}

![](images/keops.pdf){height=7cm}

`\end{center}`{=latex}


## Des interfaces haut niveau pour passer du prototype à la production


::: columns
:::: {.column width=50%}

 \
Un écosystème en construction : \
 \

- **PyG** : depuis 2018

  - $\BR{Deep learning sur les graphes.}$
  - Basé sur torch-scatter, etc. \
    \

- **PyVista** : depuis 2019

  - $\BR{Visualisation 3D.}$
  - Basé sur VTK. \
    \

- **scikit-shapes** : en cours

  - $\BR{Analyse de formes.}$
  - Basé sur KeOps.
::::
:::: {.column width=50%}
`\begin{center}`{=latex}
![](images/arteries.png){height=5.5cm}

Réseau artériel cérébral. \
Comment apprendre de cet objet ?
`\end{center}`{=latex}
::::
:::

## Conclusion

- Les **cartes graphiques** (GPUs) sont le moteur de l'IA.

- Un **environnement logiciel** $\BR{complet}$ est nécessaire, du C++ au Python.

- Depuis 2015, l'**imagerie médicale** a pu surfer sur une vague \
  d'investissement des **GAFA** pour le traitement d'$\BR{images naturelles}$. \
  \
  Avancées : **segmentation**, traitement de la **texture** et **détection** de lésions. \
  
  
- Quid de la planification **chirurgicale**, la **morphométrie**, l'analyse **vasculaire**... ? \
  \
  Un **investissement dans les** $\BR{fondations numériques}$ du domaine est en cours. \


# References