---
title: "                                         Calcul géométrique rapide                                                          .                         pour la vision et les sciences des données"
author: "Jean Feydy"
institute: "INRIA Paris"
topic: "Orasis 2021"
theme: "metropolis"
colortheme:
fonttheme:
mainfont: "Overlock"
fontsize: 11pt
linkcolor: black
urlcolor: blue
linkstyle: bold
aspectratio: 169
titlegraphic: 
logo:
date:
section-titles: false
toc: false
---


## CV : un parcours "maths-info" dirigé vers la médecine

Formation en **mathématiques** et **sciences des données** :

```{=latex}
\vspace*{-.25cm}
\begin{description}
\setlength\itemsep{-.5em}
\item[2012--2016] ENS Paris, mathématiques.
\item[2014--2015] M2 mathématiques, vision, apprentissage à l'ENS Cachan.
\item[2016--2019] Thèse en \textcolor{red!80!black}{\textbf{imagerie médicale}} avec Alain Trouvé de l'ENS Cachan.
\item[2019--2021] \textcolor{red!80!black}{\textbf{\emph{Deep learning} géométrique}} avec Michael Bronstein de l'Imperial College.
\item[2021+] \textcolor{red!80!black}{\textbf{Analyse de données médicales}} dans l'équipe HeKA, INRIA Paris.
\end{description}
\vspace*{.4cm}
```

Liens étroits avec la `\textbf{\textcolor{red!80!black}{médecine}}`{=latex} :


```{=latex}
\vspace*{-.25cm}
\begin{description}
\setlength\itemsep{-.5em}
\item[2015\phantom{+}] Débruitage d'images chez \textbf{Siemens Healthcare} à Princeton.
\item[2019+] MasterClass IA--Imagerie, pour les \textbf{internes de radio} à l'Université de Paris.
\item[2020+] Colloque sur l'\textbf{Imagerie médicale à l'heure de l'IA}, à l'Institut du Cerveau.
\end{description}
```

## Ma motivation: l'analyse de données médicales


`\vspace*{.5cm}`{=latex}

![](images/pipeline/pipeline.png){ width=100% }

`\vspace*{.25cm}`{=latex}

Trois **caractéristiques** :

- Données **hétérogènes** : parcours de soin, images, etc.
- Petits échantillons stratifiés : 10 - 1 000 patients par groupe.
- La gestions des ***outliers*** et de la **queue lourde** des distributions est une priorité.


## L'anatomie computationnelle `\cite{mammography_picture,ledig2018structural,chnafa2014image}`{=latex}

`\vspace*{.5cm}`{=latex}

::: columns

:::: {.column width=30%}

`\begin{center}`{=latex}

![](images/anatomy_problems/breast.png){height=3cm}

Détecter un objet

`\end{center}`{=latex}

::::

:::: {.column width=30%}

`\begin{center}`{=latex}

![](images/anatomy_problems/brains.jpg){height=3cm}

Analyser une variation

`\end{center}`{=latex}

::::

:::: {.column width=30%}

`\begin{center}`{=latex}

![](images/anatomy_problems/blood_flow.jpg){height=3cm}

Recaler un modèle

`\end{center}`{=latex}

::::

:::

`\vspace*{.25cm}`{=latex}

Quelques particularités, dans le contexte de la vision par ordinateur :

- Prises de vues **standardisées**, sans occlusions.
- Travail de **précision** (millimétrique).
- Importance des **garanties** de robustesse et de régularité.

## Un domaine en mutation

::: columns

:::: {.column width=70%}


`\begin{center}`{=latex}
`\vspace*{.5cm}`{=latex}
`\contexte{Enjeu.}`{=latex} Développer des modèles qui combinent \
**expertise** médicale et jeux de **données**.

`\end{center}`{=latex}

\
`\defi{Défi.}`{=latex} Arrivée des **cartes graphiques** (GPU): \
 \

- Excellent rapport **qualité-prix** : \
  $\qquad$ 1 000€ $\simeq$ 1 000 cœurs $\simeq$ $\text{10}^{\text{12}}$ opérations/s.
- **Difficulté** : contraintes sur la gestion des **registres**.

`\vspace*{.5cm}`{=latex}
`\begin{center}`{=latex}

Écosystème Python "grand public" consolidé autour \
d'un **petit nombre d'opérations élémentaires**.

`\end{center}`{=latex}

::::

:::: {.column width=25%}

`\begin{center}`{=latex}

`\vspace*{1cm}`{=latex}

![](images/ampere.jpg){height=6cm}

`\vspace*{.25cm}`{=latex}

**7,000 cœurs** en batterie sur un GPU.

`\end{center}`{=latex}

::::

:::



## Mon projet : un investissement de long terme dans les fondations du domaine

`\begin{center}`{=latex}

`\vspace*{.25cm}`{=latex}
`\solution{Solution.}`{=latex} **Étendre la boîte à outils standard** en sciences des données \
pour répondre aux défis posés par le monde médical. \
 \
**Faciliter** le développement de **modèles avancés**, \
sans compromis sur les performances numériques.

`\vspace*{.5cm}`{=latex}
`\end{center}`{=latex}

Un travail de fond,   `\solution{fondations}`{=latex}numériques $\longrightarrow$ applications de `\solution{haut niveau}`{=latex}: `\vspace*{-.25cm}`{=latex}

1. Manipulation efficace de **matrices "symboliques"** (distances, noyaux, etc.).
2. **Transport optimal** : méthodes de tri généralisées.
3. ***Deep learning*** géométrique et applications **biomédicales**.


**Avenir** de ces outils et **perspectives cliniques**.


# 1. Matrices symboliques

## Les outils de calcul scientifique manipulent (surtout) des matrices



::: columns

:::: {.column width=70%}

`\vspace*{.25cm}`{=latex}
`\contexte{Contexte.}`{=latex}
**Accès mémoires** contraignants sur GPU :
`\vspace*{.3cm}`{=latex}

- **Temps de transfert** vers les registres \
  pénalisent l'utilisation de matrices **denses**.

- Prime aux accès mémoires **contigus** \
  pénalise l'utilisation de matrices **creuses**.


\
`\defi{Défi.}`{=latex}
Pour atteindre des performances optimales :
`\vspace*{.3cm}`{=latex}

- Se **restreindre** aux opérations supportées directement
  par le constructeur: convolutions, FFT, etc.

- Développer soi-même de nouvelles routines numériques
  en C++/CUDA (FAISS, KPConv...) : **plusieurs mois de travail**.


::::

:::: {.column width=25%}

`\begin{center}`{=latex}


```{=latex}
\begin{tikzpicture}[scale=.9]
	\draw[draw=black, fill=blue!20] (0,0) rectangle ++(3,3);
	\draw[step=.15, color=gray] (0,0) grid ++(3,3);
	\draw[draw=black, thick] (0,0) rectangle ++(3,3);
	\node[inner sep=3pt, anchor = mid, fill=blue!5, rounded corners=2] at (1.5,1.5) {{\normalsize M[\,i\,,\,j\,]}};
\end{tikzpicture}
```

**Matrice dense**

```{=latex}
\vspace*{.5cm}

\begin{tikzpicture}[scale=.9]
	\draw[draw=black, thick] (0,0) rectangle ++(3,3);
	\node[inner sep=0pt, anchor = mid] at (1.5,1.5) {{\normalsize ($\text{i}_\text{n}$, $\text{j}_\text{n}$, $\text{M}_\text{n}$)}};
	\draw[fill=blue!20] (4*.15,1*.15) rectangle ++(.15,.15);
	\draw[fill=blue!20] (15*.15,1*.15) rectangle ++(.15,.15);
	%
	\draw[fill=blue!20] (2*.15,2*.15) rectangle ++(.15,.15);
	%
	\draw[fill=blue!20] (9*.15,3*.15) rectangle ++(.15,.15);
	\draw[fill=blue!20] (16*.15,3*.15) rectangle ++(.15,.15);
	%
	%\draw[fill=blue!20] (3*.15,4*.15) rectangle ++(.15,.15);
	\draw[fill=blue!20] (6*.15,4*.15) rectangle ++(.15,.15);
	\draw[fill=blue!20] (4*.15,6*.15) rectangle ++(.15,.15);
	%\draw[fill=blue!20] (14*.15,7*.15) rectangle ++(.15,.15);
	%\draw[fill=blue!20] (2*.15,7*.15) rectangle ++(.15,.15);
	%
	\draw[fill=blue!20] (18*.15,8*.15) rectangle ++(.15,.15);
	\draw[fill=blue!20] (1*.15,9*.15) rectangle ++(.15,.15);
	%\draw[fill=blue!20] (16*.15,10*.15) rectangle ++(.15,.15);
	%
	\draw[fill=blue!20] (6*.15,13*.15) rectangle ++(.15,.15);
	\draw[fill=blue!20] (16*.15,13*.15) rectangle ++(.15,.15);
	\draw[fill=blue!20] (4*.15,14*.15) rectangle ++(.15,.15);
	\draw[fill=blue!20] (12*.15,15*.15) rectangle ++(.15,.15);
	\draw[fill=blue!20] (2*.15,16*.15) rectangle ++(.15,.15);
	\draw[fill=blue!20] (10*.15,17*.15) rectangle ++(.15,.15);
\end{tikzpicture}
```

**Matrice creuse**

`\end{center}`{=latex}

::::

:::

  
## La bibliothèque KeOps: support efficace des matrices symboliques


::: columns

:::: {.column width=70%}

`\solution{Solution.}`{=latex} 
KeOps -- `\textcolor{blue}{\texttt{www.kernel-operations.io}}`{=latex} : `\vspace*{.2cm}`{=latex}

- Pour PyTorch, NumPy, Matlab et R sur **CPU et GPU**.
- **Différentiation automatique**.
- **Compilation** à la volée de **schémas optimisés** en C++, \
  exécutés pour chaque **réduction** (somme, min, etc.).

\
Si la formule "F" est simple ($\leqslant$ 100 opérations arithmétiques): \
$\qquad$ calcul "100k $\times$ 100k"   $\rightarrow$  10ms -- 100ms, \
$\qquad$ calcul    "1M $\times$ 1M"      $\rightarrow \phantom{\text{0m}}$ 1s -- 10s.

`\vspace*{.5cm}`{=latex}

`\begin{center}`{=latex}

Limite matérielle de $\text{10}^{\text{12}}$ opérations/s. \
Exécution **10 à 100 fois plus rapide** / code GPU standard \
pour une large gamme de problèmes.

`\end{center}`{=latex}

::::

:::: {.column width=25%}

`\begin{center}`{=latex}



```{=latex}
\begin{tikzpicture}[scale=.9]
	% Left border:
	\draw[draw=black, fill=red!20] (-.45,0) rectangle ++(.3,3);
	\draw[draw=black, fill=red!80] (-.45,9*.15) rectangle ++(.3,.15);
	\draw[step=.15, color=gray] (-.45,0) grid ++(.3,3);
	\draw[draw=black] (-.45,0) rectangle ++(.3,3);
	%
	% Top border:
	\draw[draw=black, fill=green!20] (0,3.15) rectangle ++(3,.3);
	\draw[draw=black, fill=green!80] (6*.15,3.15) rectangle ++(.15,.3);
	\draw[step=.15, color=gray] (0,3.15) grid ++(3,.3);
	\draw[draw=green!50!black] (0,3.15) rectangle ++(3,.3);
	%
	\draw[draw=black,thick] (0,0) rectangle ++(3,3);
	%
	\draw[->, thick, color=red!80!black] (.5*.15, 9.5*.15) -- (5*.15, 9.5*.15);
	\draw[->, thick, color=green!50!black] (6.5*.15, 19.5*.15) -- (6.5*.15, 11*.15);
	%
	\draw[fill=blue!40] (6*.15,9*.15) rectangle ++(.15,.15);
	\node[inner sep=0pt, anchor = mid, color=blue!50!black] at (1.95,1.4) {\normalsize{F(\,\textcolor{red!80!black}{$\text{x}_\text{i}$}\,,\,\textcolor{green!50!black}{$\text{y}_\text{j}$}\,)}};
\end{tikzpicture}
```

**Matrice symbolique** \
Formules + données
 

`\end{center}`{=latex}
`\vspace*{.5cm}`{=latex}


- Distances `d(\textcolor{red!80!black}{$\text{x}_\text{i}$},\textcolor{green!50!black}{$\text{y}_\text{j}$})`{=latex}.
- Noyaux `k(\textcolor{red!80!black}{$\text{x}_\text{i}$},\textcolor{green!50!black}{$\text{y}_\text{j}$})`{=latex}.
- Nombreuses transformées.


::::

:::


```{=latex}

\end{frame}

\begin{frame}[fragile]{Premier exemple : la recherche de plus proches voisins}

On crée de grands nuages de points avec \textbf{la syntaxe PyTorch standard}:
\vspace*{-.3cm}
\begin{minted}[bgcolor=blue!4,fontsize=\footnotesize,mathescape,tabsize=4,escapeinside=||]{python}
import torch
N, M, D = 10**6, 10**6, 50
x = torch.rand(N, 1, D).cuda()  # (1M,  1, 50) array
y = torch.rand(1, M, D).cuda()  # ( 1, 1M, 50) array
\end{minted}

%\pause
\vspace*{-.6cm}
On convertit les tableaux \textbf{denses} en matrices \textbf{symboliques} :
\vspace*{-.3cm}
\begin{minted}[bgcolor=blue!4,fontsize=\footnotesize,mathescape,tabsize=4,escapeinside=||,highlightlines={1-2}]{python}
from pykeops.torch import LazyTensor
x_i, y_j = LazyTensor(x), LazyTensor(y)
\end{minted}

%\pause
\vspace*{-.6cm}
On crée une grande \textbf{matrice symbolique} des distances au carré :
\vspace*{-.3cm}
\begin{minted}[bgcolor=blue!4,fontsize=\footnotesize,mathescape,tabsize=4,escapeinside=||]{python}
D_ij = ((x_i - y_j) ** 2).sum(dim=2)  # (1M, 1M) symbolique
\end{minted}

%\pause
\vspace*{-.6cm}
On utilise une \textbf{réduction} \texttt{.argmin()} pour chercher les plus proches voisins :
\vspace*{-.3cm}
\begin{minted}[bgcolor=blue!4,fontsize=\footnotesize,mathescape,tabsize=4,escapeinside=||]{python}
indices_i = D_ij.argmin(dim=1)  # -> tenseur torch standard
\end{minted}

\end{frame}


\begin{frame}[fragile]{La bibliothèque KeOps combine performances et flexibilité}

\begin{center}

```

Code précédent = méthode **compétitive** avec \
les implémentations C++/CUDA de référence (**FAISS**)... \
Et qui peut être utilisée avec **n'importe quelle métrique** !

```{=latex}
\end{center}

\begin{minted}[bgcolor=blue!4,fontsize=\footnotesize,mathescape,tabsize=4]{python}
D_ij = ((x_i - x_j) ** 2).sum(dim=2)     # Euclidienne
M_ij =  (x_i - x_j).abs().sum(dim=2)     # Manhattan
C_ij = 1 - (x_i | x_j)                   # Cosinus
H_ij = D_ij / (x_i[...,0] * x_j[...,0])  # Hyperbolique
\end{minted}

\vspace*{-.4cm}
```

KeOps supporte des **formules** et **variables** arbitraires avec :

- **Réductions:** somme, log-sum-exp, K-min, produit matrice-vecteur, etc.
- **Opérations:** $+$, $\times$, sqrt, exp, réseaux de neurones, etc.
- **Schémas avancés:** calcul par batches, parcimonie par blocs, etc.
- **Différentiation automatique:** intégration complète avec PyTorch.

```{=latex}
\end{frame}

\begin{frame}{KeOps nous permet de tirer le meilleur parti de notre matériel, simplement}

\begin{center}
	Benchmark d'une \textbf{convolution} avec un noyau Gaussien,\\
	entre \textbf{nuages de N points 3D} sur un GPU RTX 2080 Ti. 
	%\vspace*{-.3cm}

	\resizebox{.85\linewidth}{!}{\input{images/benchmarks/benchmark_gaussianconv.tex}}
\end{center}
```

# Applications

## KeOps facilite la recherche en apprentissage machine

::: columns

:::: {.column width=50%}

`\begin{center}`{=latex}

![](images/applications/kmeans_2D.png){height=5cm}

`\vspace*{.25cm}`{=latex}
K-Means.
`\end{center}`{=latex}

::::


:::: {.column width=50%}

`\begin{center}`{=latex}

![](images/applications/GMM.png){height=5cm}

`\vspace*{.25cm}`{=latex}
Mixtures de Gaussiennes.
`\end{center}`{=latex}

::::

:::

`\begin{center}\vspace*{.3cm}`{=latex}
KeOps est utilisable avec la formule, distance ou noyau de **votre choix** !
`\end{center}`{=latex}


## KeOps facilite la recherche en apprentissage machine

::: columns

:::: {.column width=50%}

`\begin{center}`{=latex}

![](images/applications/spectral.png){height=5cm}

`\vspace*{.25cm}`{=latex}
Analyse spectrale.
`\end{center}`{=latex}

::::


:::: {.column width=50%}

`\begin{center}`{=latex}

![](images/applications/WordNet.png){height=5cm}

`\vspace*{.25cm}`{=latex}
UMAP dans un espace hyperbolique.
`\end{center}`{=latex}

::::

:::

`\begin{center}\vspace*{.21cm}`{=latex}
KeOps est utilisable avec la formule, distance ou noyau de **votre choix** !
`\end{center}`{=latex}


## Applications au Krigeage, aux splines, aux processus Gaussiens et aux noyaux

**Un outil standard pour la régression** `\cite{leclercq2018bayesian}`{=latex} :

`\begin{center}`{=latex}

![](images/applications/GP_regression.png){height=3.5cm}

`\end{center}`{=latex}

Sous le capot, on résout un **système linéaire à noyaux** :

`\vspace*{-.5cm}`{=latex}

$$ (\lambda \,\text{Id} + K_{xx}) \,a ~=~b 
\qquad\text{i.e.}\qquad
a ~\gets~(\lambda \,\text{Id} + K_{xx})^{-1} b $$

où $~~\lambda \geqslant 0~~$ et $~~(K_{xx})_{i,j} = k(x_i,x_j)~~$ est une matrice symétrique, définie positive.


## Applications au Krigeage, aux splines, aux processus Gaussiens et aux noyaux

**Les tenseurs symboliques $~~(K_{xx})_{i,j} = k(x_i,x_j)~$:**

- Peuvent être interfacés avec des **solveurs standards**: SciPy, GPyTorch, etc. \

- GPyTorch sur le jeu de données 3DRoad (N = 278k, D = 3) :
  `\centerline{\defi{\textbf{7h} avec 8 GPUs} $~~\rightarrow~~$ \solution{\textbf{15mn} avec 1 GPU.}}`{=latex} \
   \

- Fournissent une **plateforme efficace et flexible** pour les projets de recherche :\
  voir par exemple *Kernel methods through the roof: handling **billions of points** efficiently*, \
  par G. Meanti, L. Carratino, L. Rosasco, A. Rudi (2020).


## KeOps permet aux chercheurs de se concentrer sur leurs modèles

Quelques applications aux **systèmes dynamiques** `\cite{degond2008continuum,degond2017alignment}`{=latex} \
et aux **statistiques** `\cite{CMC}`{=latex} avec A. Diez, G. Clarté et P. Degond:

::: columns

:::: {.column width=50%}

`\begin{center}`{=latex}

![](images/applications/Vicsek_3D.png){height=4cm}

`\vspace*{.25cm}`{=latex}
Modèle de Vicsek orienté en 3D, \
démo interactive avec 2k **oiseaux**.
`\end{center}`{=latex}

::::


:::: {.column width=50%}

`\begin{center}`{=latex}

![](images/applications/Vicsek_2D.png){height=4cm}

`\vspace*{.25cm}`{=latex}
Modèle de Vicsek 2D sur le tore, \
en temps réel avec 100k **nageurs**.
`\end{center}`{=latex}

::::

:::



## KeOps permet aux chercheurs de se concentrer sur leurs modèles

$\qquad\qquad\Longrightarrow~~$ On simule plusieurs **millions d'agents** avec de simples scripts Python. \

::: columns

:::: {.column width=50%}

`\begin{center}`{=latex}

![](images/applications/packing.png){height=4cm}

`\vspace*{.25cm}`{=latex}
Problème de ***packing*** \
avec 10k boules répulsives.
`\end{center}`{=latex}

::::


:::: {.column width=50%}

`\begin{center}`{=latex}

![](images/applications/CMC_hyperbolic.png){height=4cm}

`\vspace*{.25cm}`{=latex}
**Échantillonnage** de Monte Carlo Collectif \
dans un espace hyperbolique.
`\end{center}`{=latex}

::::

:::




# 2. Transport optimal

## Le transport optimal (OT) généralise le tri aux espaces de dimension D $>$ 1



::: columns

:::: {.column width=70%}


`\contexte{Contexte.}`{=latex}
Si  $\a{\text{A} = (\text{x}_\text{1}, \dots, \text{x}_\text{N})}$  et  $\b{\text{B} = (\text{y}_\text{1}, \dots, \text{y}_\text{N})}$  sont deux nuages de N points dans $\mathbb{R}^\text{D}$,
on définit :




```{=latex}
\vspace*{-.3cm}
\begin{equation*}
\OT(\a{\text{A}},\b{\text{B}}) ~=~ \min_{\sigma \in \mathcal{S}_\text{N}}~ \frac{\text{1}}{\text{2N}} \sum_{\text{i\,=1}}^\text{N} \v{\|~\a{\text{x}_i} - \b{\text{y}_{\sigma(i)}}\|^2}
\end{equation*}
\vspace*{.2cm}
```

Généralise le **tri** aux espaces métriques. \
**Problème linéaire** sur la matrice de permutation $\g{\text{P}}$ :

```{=latex}
\begin{equation*}
\OT(\a{\text{A}},\b{\text{B}}) ~=~ \min_{\g{\text{P}} \in \mathbb{R}^{\text{N}\times \text{N}} ~}
\frac{\text{1}}{\text{2N}} \sum_{\text{i, j\,=1}}^{\text{N}} \g{\text{P}_{i,j}} \cdot \v{ \|~ \a{\text{x}_i} - \b{\text{y}_j} \|^2 }~,
\end{equation*}
\vspace*{-.6cm}
\begin{align*}
&\text{s.t.} &
\g{ \text{P}_{i,j}} ~&\geqslant ~\text{0} &
\underbrace{\b{\textstyle\sum_j} \g{ \text{P}_{i,j}} ~=~ \a{\text{1}}}_{\text{Chaque point au départ\dots{}}}& &
\underbrace{\vphantom{\textstyle\sum_j}\a{\textstyle\sum_i} \g{ \text{P}_{i,j}} ~=~ \b{\text{1}}~.}_{\text{est transporté jusqu'à l'arrivée.}}
\end{align*}

```

::::

:::: {.column width=25%}

```{=latex}
\begin{center}
	\begin{tikzpicture}[scale=.5,x=.7cm,y=-.7cm]
		%\node[anchor = east] at (0,4) {source};
		\draw[->,>=latex,thick,color=black]  (0,0)--(0,16.5);
		\node[circle,fill=red!80!black,inner sep=0pt,minimum size=7pt,label=left:{$\a{\text{x}_\text{1}}$}] (x1) at (0,1) {};
		\node[circle,fill=red!80!black,inner sep=0pt,minimum size=7pt,label=left:{$\a{\text{x}_\text{2}}$}] (x2) at (0,2) {};
		\node[circle,fill=red!80!black,inner sep=0pt,minimum size=7pt,label=left:{$\a{\text{x}_\text{3}}$}] (x3) at (0,3.5) {};
		\node[circle,fill=red!80!black,inner sep=0pt,minimum size=7pt,label=left:{$\a{\text{x}_\text{4}}$}] (x4) at (0,5) {};
		\node[circle,fill=red!80!black,inner sep=0pt,minimum size=7pt,label=left:{$\a{\text{x}_\text{5}}$}] (x5) at (0,7.5) {};


		%\node[anchor = east] at (0,0) {cible};
		\draw[->,>=latex,thick,color=black]  (4,0)--(4,16.5);
		\node[circle,fill=blue,inner sep=0pt,minimum size=7pt,label=right:{$\b{\text{y}_\text{3}}$}] (y1) at (4,5.5) {};
		\node[circle,fill=blue,inner sep=0pt,minimum size=7pt,label=right:{$\b{\text{y}_\text{5}}$}] (y2) at (4,7) {};
		\node[circle,fill=blue,inner sep=0pt,minimum size=7pt,label=right:{$\b{\text{y}_\text{2}}$}] (y3) at (4,8.5) {};
		\node[circle,fill=blue,inner sep=0pt,minimum size=7pt,label=right:{$\b{\text{y}_\text{4}}$}] (y4) at (4,12.5) {};
		\node[circle,fill=blue,inner sep=0pt,minimum size=7pt,label=right:{$\b{\text{y}_\text{1}}$}] (y5) at (4,15) {};

		\node[anchor = north, align=center, color=otplan!70!black] at (2,17) {{assignement}\\ ${\sigma:\zp[i]{1,5}\rightarrow \zp[i]{1,5}}$};

		\draw[color=otplan,very thick] (x1) -- (y1) (x2) -- (y2) (x3) -- (y3) (x4) -- (y4) (x5) -- (y5);

		%\onslide<2,3,4,6->{\draw[color=green!80!black,thick] (x3) -- (y3) (x4) -- (y4);}
		%\onslide<5>{\draw[color=green!80!black] (x4) -- (y3);
		%\draw[color=green!80!black, very thick] (x3) -- (y4);}

	\end{tikzpicture}
	\end{center}
```

::::

:::

## Propriétés clés de cette distance "à permutation près"

La distance de Wasserstein $\sqrt{\OT}(\a{\text{A}},\b{\be})$ est :

- **Symétrique** : $\qquad\qquad\qquad \OT(\a{\text{A}},\b{\be}) = \text{OT}(\b{\be},\a{\text{A}})\,$.
- **Positive** : $\qquad\qquad\qquad\qquad \OT(\a{\text{A}},\b{\be}) \geqslant \text{0} \,$.
- **Définie** : $\qquad\qquad~~~~~~\OT(\a{\text{A}},\b{\be})=\text{0} \Longleftrightarrow  \a{\text{A}} = \b{\be}\,$.
- **Compatible avec les translations** : $\OT(\a{\text{A}},\,\text{Translation}_{\v{\vec{v}}}(\a{\text{A}})\,) = \tfrac{1}{2}\|\, \v{\vec{v}}\,\|^2\,$. \

- Plus généralement, OT retrouve l'unique
  **gradient d'une fonction convexe** \
  $\text{T} = \nabla \phi$ qui envoie $\a{\text{A}}$ sur $\b{\be}$ :

```{=latex}
\vspace*{-1cm}
\begin{alignat*}{10}
\text{En dimension~}&\text{1}, &\qquad& 
(\a{\text{x}_\text{i}} - \a{\text{x}_\text{j}})&~\cdot~& (\b{\text{y}_{\sigma(\text{i})}} - \b{\text{y}_{\sigma(\text{j})}}) 
~&&\geqslant~ \text{0}  \\
\text{En dimension~}&\D, && 
\langle\, \a{\text{x}_\text{i}} - \a{\text{x}_\text{j}} \,&~,~&\, \b{ \text{T}(\text{x}_\text{i}) } - \b{ \text{T}(\text{x}_\text{j})  } \,\rangle_{\R^\D}
~&&\geqslant~ \text{0} ~.
\end{alignat*}
```

```{=latex}
%\vspace{-.5cm}
\begin{center}
$\Longrightarrow\qquad$ Généralisation attrayante de la notion d'\textbf{application croissante}.
\end{center}


\end{frame}

\begin{frame}{Un exemple simple en 2D}

	\vspace{.3cm}
	\begin{center}
		\includegraphics<1>[height=.8\textheight]{images/flows_2D/sinkhorn_multiscale_L2_001/000.png}%
		\includegraphics<2>[height=.8\textheight]{images/flows_2D/sinkhorn_multiscale_L2_001/025.png}%
		\includegraphics<3>[height=.8\textheight]{images/flows_2D/sinkhorn_multiscale_L2_001/050.png}%
		\includegraphics<4>[height=.8\textheight]{images/flows_2D/sinkhorn_multiscale_L2_001/100.png}%
		\includegraphics<5>[height=.8\textheight]{images/flows_2D/sinkhorn_multiscale_L2_001/500.png}%
		\includegraphics<6>[height=.8\textheight]{images/flows_2D/sinkhorn_multiscale_L2_001/1000.png}%
	\end{center}
	
	%\vspace{-.5cm}
	\hspace*{6cm}
	$\text{t} = $ %
	\only<1>{\texttt{.00}}%
	\only<2>{\texttt{.25}}%
	\only<3>{\texttt{.50}}%
	\only<4>{\texttt{1.00}}%
	\only<5>{\texttt{5.00}}%
	\only<6>{\texttt{10.00}}%

\end{frame}


\begin{frame}{Un modèle efficace... Mais attention aux déchirures !}
	\vspace*{1cm}

	\centerline{
	\begin{tabular}{ccc}
	\includegraphics<1>[height=6cm]{images/registration_2D/densities/000.png}%
	\includegraphics<2>[height=6cm]{images/registration_2D/crescents/000.png}%
	\includegraphics<3>[height=6cm]{images/registration_2D/worms/000.png}%
	\includegraphics<4>[height=6cm]{images/registration_2D/moons/000.png}%
	&\qquad&
	\includegraphics<1>[height=6cm]{images/registration_2D/densities/010.png}%
	\includegraphics<2>[height=6cm]{images/registration_2D/crescents/010.png}%
	\includegraphics<3>[height=6cm]{images/registration_2D/worms/010.png}%
	\includegraphics<4>[height=6cm]{images/registration_2D/moons/010.png}%
	\\
	Avant
	&&
	Après
	\end{tabular}
	}

```


## Solutions géométriques aux problèmes des moindres carrés `\cite{agueh_2011}`{=latex}

```{=latex}
\vspace*{-.5cm}
\begin{align*}
	\text{Barycentre}~~\a{\al^*}
	~=~\arg \min_{\a{\al}} 
	\sum_{i=1}^4 \,\lambda_i\,\text{Loss}(\,\a{\al}\,,\, \b{\be_i}\,)~.
\end{align*}
```

::: columns

:::: {.column width=45%}

`\begin{center}`{=latex}

![](images/wasserstein/linear_barycenters.png){height=60%}

Barycentres **euclidiens**. \
$\text{Loss}(\a{\al},\b{\be}) = \|\a{\al}-\b{\be}\|^2_{L^2}$

`\end{center}`{=latex}

::::

:::: {.column width=45%}

`\begin{center}`{=latex}

![](images/wasserstein/wasserstein_barycenters.png){height=60%}

Barycentres de **Wasserstein**. \
$\text{Loss}(\a{\al},\b{\be}) = \OT(\a{\al},\b{\be})$

`\end{center}`{=latex}

::::

:::




## Régularisation et biais entropique


::: columns

:::: {.column width=75%}

`\begin{center}\vspace*{.25cm}`{=latex}

`\defi{Défi.}`{=latex}
Assignement linéaire  : difficile à résoudre en toute généralité. \
**Structure** de la matrice des distances $\v{ \|\,\a{\text{x}_i} -\b{\text{y}_j} \| }$ \
$\Longrightarrow$ **Accélérer** les calculs. \
 

Outil fondamental : le **transport régularisé** \
$\OT_\varepsilon(\a{\text{A}}, \b{\text{B}}) \simeq \OT(\a{\text{A}}, \b{\text{B}}) +$ **pénalité entropique** d'intensité  $\varepsilon > \text{0}$. \
 

Approximation **lisse** et strictement **convexe** : plus facile à étudier,\
très populaire algorithme de **Sinkhorn** (ou "*SoftAssign*").\
 

En revanche, elle ne **vérifie pas les axiomes d'une distance** : \
$\OT_\varepsilon(\b{\text{B}}, \b{\text{B}}) > \text{0}$.

`\end{center}`{=latex}

::::

:::: {.column width=22%}


`\begin{center}`{=latex}

![](images/bias/entropic_bias_vertical_gris.png){height=6cm}

$\arg \min_{\a{\text{A}}}
\OT_\varepsilon(\a{\text{A}}, \b{\text{B}})$.

`\end{center}`{=latex}


::::

:::

## Solution théorique : garantie de robustesse au biais entropique


::: columns

:::: {.column width=75%}


`\begin{center}`{=latex}


`\solution{Solution.}`{=latex} 
Les **divergences de Sinkhorn** sont définies par : \
$\S_\varepsilon(\a{\al}, \b{\be}) = \OT_\varepsilon(\a{\al}, \b{\be}) - \tfrac{1}{2} \OT_\varepsilon(\a{\al}, \a{\al}) - \tfrac{1}{2} \OT_\varepsilon(\b{\be}, \b{\be})$ \
afin de retrouver une valeur nulle lorsque $\a{\text{A}} = \b{\text{B}}$.

`\end{center}`{=latex}


```{=latex}
\vspace*{.25cm}

\begin{theorem}[~$\S_\varepsilon$ se prête bien à l'optimisation]
	\hspace*{5mm}Pour tous échantillons~~$\a{\al}$~~et~~$\b{\be}$~:
	\begin{center}\vspace{-.1cm}
		$\S_\varepsilon(\a{\al},\b{\be})~\geqslant~\text{0}$
		~~~avec égalité ssi.~~~$\a{\al}=\b{\be}$~, \\[.1cm]
		$\a{\al}\mapsto \S_\varepsilon(\a{\al},\b{\be})$
		~~est convexe au sens des mesures, \\
		différentiable et métrise la convergence en loi.\\[.3cm]
	\end{center}
	\hspace*{5mm}On généralise ce résultat aux \textbf{mesures} de Radon positives,\\
	\hspace*{5mm} à des \textbf{métriques} $\v{ \|\,\a{\text{x}_i} -\b{\text{y}_j} \| }$ générales et au cas ``\textbf{unbalanced}''.
	\vspace{.3cm}
\end{theorem}


```

::::

:::: {.column width=22%}

`\begin{center}`{=latex}

![](images/bias/Seps_slope_gris.png){height=6cm}

$\arg \min_{\a{\text{A}}}
\S_\varepsilon(\a{\text{A}}, \b{\text{B}})$.

`\end{center}`{=latex}


::::

:::


## En pratique, comment résoudre le problème de transport optimal ?

Dates clés pour le transport optimal avec N points :

- `\cite{kantorovich1942translocation}`{=latex} : problème `\defi{dual}`{=latex}de Kantorovitch.
- `\cite{kuhn1955hungarian}`{=latex} : algorithme `\defi{hongrois}`{=latex}en $O(\text{N}^3)$.
- `\cite{bertsekas79auction}`{=latex} : méthode des **enchères** en $O(\text{N}^2)$.
- `\cite{kosowsky1994invisible}`{=latex} : **SoftAssign** = Sinkhorn + recuit simulé, en $O(\text{N}^2)$.
- `\cite{gold1998new,TPSRPM}`{=latex} : **Robust Point Matching** = Sinkhorn comme fonction d'erreur.
- `\cite{CuturiSinkhorn}`{=latex} : utilisation des `\contexte{GPUs.}`{=latex}
- `\cite{merigot2011multiscale,levy2015numerical,schmitzer2019stabilized}`{=latex} : solveurs **multi-échelles** en $O(\text{N}\log \text{N})$. \
  $~$
- `\solution{Solution,}`{=latex}aujourd'hui : **algorithme de Sinkhorn multi-échelles, sur GPU**.


`\begin{center}`{=latex}
$\Longrightarrow~~~$ Algorithme de `\solution{tri rapide}`{=latex}généralisé.
`\end{center}`{=latex}


## Solution pratique : l'algorithme de Sinkhorn multi-échelles

```{=latex}

\begin{center} 
	Entre 2015 et 2020, l'état de l'art pour le transport
	optimal discret a été amélioré par \\
	\textbf{un à trois ordres de grandeur} -- selon le régime d'utilisation :
	
	Sinkhorn GPU
	$\xrightarrow{\times \text{10}}$
	+ KeOps
	$\xrightarrow{\times \text{10}}$
	+ Recuit simulé
	$\xrightarrow{\times \text{10}}$
	+ Multi-échelle
	
	
	Résoudre un problème de transport avec une précision de 1\% :\\~
	\end{center}

	\vspace*{-.25cm}
	\begin{tabular}{cccc}
	\begin{minipage}{.2\linewidth}
	\begin{center}
	~\\
	\texttt{pip install geomloss}\\
	+\\
	GPU récent\\ (1 000 €)
	\end{center}
	\end{minipage}
	&
	\begin{minipage}{.1\linewidth}
	~\\
	$\Longrightarrow$
	\end{minipage}
	&
	\begin{minipage}{.3\linewidth}
	\includegraphics[height=3.5cm]{images/dragon_ball/lowres.png}
	\end{minipage}
	&
	\begin{minipage}{.3\linewidth}
	\includegraphics[height=3.5cm]{images/dragon_ball/highres.png}
	\end{minipage}
	\\
	&&
	10k points en 30-50ms
	&
	\textbf{100k points en 100-200ms}
	\end{tabular}
```


# 3. Deep learning géométrique

## Concevoir des modèles entraînables et adaptés aux experts



::: columns

:::: {.column width=75%}

`\vspace*{.1cm}`{=latex}
`\contexte{Enjeu.}`{=latex}
Modèles profonds sur des **domaines non-euclidiens**
(nuages de points, surfaces, graphes, etc.),
au-delà des images 2D/3D.

\
`\defi{Défi.}`{=latex}
En dépit d'un intérêt industriel croissant, \
ces modèles restent **mal supportés** numériquement. \
Le C++/CUDA reste (souvent) incontournable.


\
`\solution{Solution.}`{=latex}
En quelques lignes de Python,
avec KeOps :


- Interactions **locales**: K-plus-proches voisins.
- Interactions **globales**: convolutions généralisées.

`\vspace*{.35cm}\begin{center}`{=latex}

**Liberté** de modélisation \
$\Longrightarrow$  **Spécificités** des domaines étudiés.

`\end{center}`{=latex}

::::

:::: {.column width=22%}

`\begin{center}`{=latex}

![](images/applications/coordinates_gris.png){height=6cm}

Convolution quasi-géodésique sur un nuage de points orientés.

`\end{center}`{=latex}


::::

:::



## Benchmarks de quelques "convolutions" sur ShapeNet (N = 2,048 points 3D)

```{=latex}
\begin{center}

\vspace*{-.4cm}

\begin{align*}
\text{f}_\text{i} ~\gets~ 
\textcolor{red!65!black}{
\sum_{\text{x}_\text{j} \in \text{KNN}(\text{x}_\text{i})}
\text{Conv}(\text{x}_\text{i}, \text{x}_\text{j}, \text{f}_\text{j})}
\qquad
\text{ou}
\qquad
\textcolor{green!60!black}{
\sum_{\text{tous les}~\text{x}_\text{j}}
\exp(-\|\text{x}_\text{i} - \text{x}_\text{j}\|^2 / 2\sigma^2) \cdot
\text{Conv}(\text{x}_\text{i}, \text{x}_\text{j}, \text{f}_\text{j})}
\qquad
\end{align*}

\vspace*{-.3cm}

\hspace*{-.6cm}
\begin{tabular}{l@{\hskip .7cm}c@{\hskip .7cm}cc@{\hskip .7cm}cc}
	\toprule
	& PyTorch          & \multicolumn{2}{c}{JAX~~~~}        & \multicolumn{2}{c}{\textbf{KeOps}  }                                             \\
	Primitive $\text{Conv}(\text{x}_\text{i}, \text{x}_\text{j}, \text{f}_\text{j})$                     & \textcolor{red!65!black}{40-NN}            & \textcolor{red!65!black}{40-NN}                              & \textcolor{green!60!black}{Gaussien}                                 & \textcolor{red!65!black}{40-NN}                  & \textcolor{green!60!black}{Gaussien} \\
	\midrule
	% Spectral coordinates & \\
	Moyennes locales                   &
	686 \textmu{}s                 & 1,052 \textmu{}s & 469 \textmu{}s                     & 121 \textmu{}s                             & \textcolor{green!60!black}{\textbf{12 \textmu{}s}}              \\
	Matrices de covariances                  &
	700 \textmu{}s                 & 1,093 \textmu{}s & 1,259 \textmu{}s                   & 138 \textmu{}s                             & \textcolor{green!60!black}{\textbf{23 \textmu{}s}}              \\
	% Distance to tangent planes & \\
	\midrule
	MLP ($\mathrm{H}=\texttt{~8}$) &
	737 \textmu{}s                 & 1,180 \textmu{}s & 4,089 \textmu{}s                   & 192 \textmu{}s                             & \textcolor{green!60!black}{\textbf{75 \textmu{}s}}              \\
	MLP ($\mathrm{H}=\texttt{16}$) &
	775 \textmu{}s                 & 1,253 \textmu{}s & 7,043 \textmu{}s                   & \textcolor{red!65!black}{\textbf{240 \textmu{}s}}                    & 649 \textmu{}s~~                    \\
	%\midrule
	%Distance de chamfer                   & 374 \textmu{}s   & \multicolumn{2}{c}{130 \textmu{}s} & \multicolumn{2}{c}{\textbf{21 \textmu{}s}}                                       \\
	%Distance à noyaux                  & 486 \textmu{}s   & \multicolumn{2}{c}{378 \textmu{}s} & \multicolumn{2}{c}{\textbf{31 \textmu{}s}}                                       \\
	\bottomrule
\end{tabular}


\vspace*{-.3cm}

~\\
Les interactions \textcolor{green!60!black}{``entre tous les points''} deviennent \textbf{viables} :\\
nous ne sommes plus obligés de nous restreindre à des convolutions\\
très locales sur un graphe de \textcolor{red!65!black}{K-plus-proches voisins}.
\end{center}
\end{frame}

\begin{frame}{Application au \emph{docking} de protéines~\cite{dmasif}}
	\vspace*{.5cm}
	\begin{figure}
		\begin{subfigure}[t]{0.35\textwidth}
			\centering
			\includegraphics[width=\textwidth]{figures/proteins/greenatoms_atoms.png}
			\caption{Données brutes : atomes en 3D.}
		\end{subfigure}
		\hfill
		\begin{subfigure}[t]{0.3\textwidth}
			\centering
			\includegraphics[width=.67\textwidth]{figures/proteins/mesh_no_edges.png}
			\caption{Interface observée.}
		\end{subfigure}
		\hfill
		\begin{subfigure}[t]{0.3\textwidth}
			\centering
			\includegraphics[width=.67\textwidth]{figures/proteins/output.png}
			\caption{Prédiction du modèle.}
		\end{subfigure}
		\vspace{.2cm}
	\end{figure}
\end{frame}



\begin{frame}{``Fast end-to-end learning on protein surfaces''~\cite{dmasif}}
	\vspace*{.5cm}
	\begin{center}
		%\includegraphics[width=1.0\linewidth]{figures/overview.pdf}
		{\scriptsize
			\def\svgwidth{\linewidth}\vspace{-2mm}
			\import{figures/}{overview.pdf_tex}
		}
	\end{center}
    \vspace{.5cm}
    
	\centerline{
	\begin{tabular}{ccc}
	\hspace*{2cm}
		\begin{minipage}{2cm}
			\includegraphics[width=\linewidth]{figures/nature_cover.png}
		\end{minipage}
		&{\huge $\longrightarrow$}
		&
		\begin{minipage}{7cm}
			$\times$100\,--$\times$1,000 plus rapide, léger\\
			\phantom{.}~et complètement différentiable.
		\end{minipage}
	\end{tabular}
	}
```

## Application à l'appariement de poumons "Expiration -- Inspiration"

`\begin{center}`{=latex}

![](images/applications/poumons.png){height=85%}

`\end{center}\vspace*{-.3cm}`{=latex}

Déformations **complexes**, haute **résolution** (50k--300k points), haute **précision** ($<$ 1mm).

## Un recalage en trois temps

On combine :

1. Un **pré-recalage** global :                       OT + déformation affine.
2. Un **recalage** "au centimètre près" :   réseau multi-échelles + difféomorphisme.
3. Un **affinage** "au millimètre près" :      OT + régularisation spline.

 \
Cette méthode **pragmatique** :

- Est **facile à entraîner** sur des données synthétiques.
- Passe à l'échelle : 100k points en $<$ 1s.
- Donne d'excellents résultats : **KITTI** (*scene flow*) et **DirLab** (poumons).


## Un recalage en trois temps


`\begin{center}`{=latex}

![](images/applications/lung_registration/full.png){height=85%}

`\end{center}\vspace*{-.3cm}`{=latex}

*Accurate point cloud registration with **robust** optimal transport* : à paraître à la fin du mois.



## Bilan : un investissement de long terme qui porte ses fruits

Deux évolutions majeures:

- "Gros" problème géométrique :     N $>$ **10k**    $\longrightarrow$    N $>$ **1M**.
- Transport optimal :            **problème** linéaire    $\,\,+\,\,$    **tri rapide** généralisé.



`\begin{center}`{=latex}
`\vspace*{.75cm}`{=latex}

![](images/projet/bilan.pdf){width=90%}

`\end{center}`{=latex}


# Avenir de ces outils, `\\`{=latex} contexte scientifique

## Un réel travail d'équipe

```{=latex}
\vspace*{.5cm}

\centerline{
\begin{tabular}{cccc}
\includegraphics[height=2cm]{images/sourires/medaillons/Alain_2.png}
&
\includegraphics[height=2cm]{images/sourires/medaillons/Thibault_2.png}
&
\includegraphics[height=2cm]{images/sourires/medaillons/FX_2.png}
&
\includegraphics[height=2cm]{images/sourires/medaillons/Gabriel_2.png}
\\
Alain Trouvé
&
\textcolor{red!65!black}{Thibault Séjourné}
&
\textcolor{red!65!black}{F.-X. Vialard}
&
\textcolor{red!65!black}{Gabriel Peyré}
\\[.5cm]
\includegraphics[height=2cm]{images/sourires/medaillons/Benjamin_2.png}
&
\includegraphics[height=2cm]{images/sourires/medaillons/Joan_2.png}
&
\includegraphics[height=2cm]{images/sourires/medaillons/Freyr.png}
&
\includegraphics[height=2cm]{images/sourires/medaillons/Zhengyang.png}\\
\textcolor{blue!100!black}{Benjamin Charlier}
&
\textcolor{blue!100!black}{Joan Glaunès}
&
\textcolor{green!60!black}{Freyr Sverrisson}
&
\textcolor{green!60!black}{Shen Zhengyang}\\[.5cm]
\multicolumn{4}{c}{+ Marc Niethammer, Bruno Correia, Michael Bronstein\dots{}}
\end{tabular}
}


\end{frame}


\begin{frame}{Promouvoir des interactions entre domaines}
\vspace*{.2cm}

\begin{center}
	\includegraphics<1>[width=.75\linewidth]{images/interactions/labels.png}%
	\includegraphics<2>[width=.75\linewidth]{images/interactions/people_behind_labels.png}%
\end{center}
```

## La révolution Python

`\begin{center}\vspace*{.3cm}`{=latex}

L'émergence d'une boîte à outils ouverte et `\solution{\textbf{modulaire}}`{=latex} \
a été une **bénédiction** pour la communauté. \
 \

Les bibliothèques de *deep learning* ont mis le **calcul sur GPU**  \
et la **différentiation automatique** à la portée de tous. \
(Incroyable !) \
 \

Ces logiciels sont soutenus par des
acteurs **industriels majeurs** (Google, Facebook...) \
et ont permis à nos domaines **d'exploser** au cours de la dernière décennie. \
 \

`\solution{\textbf{Interagir}}`{=latex}avec d'autres chercheurs, des médecins \
et des ingénieurs n'a jamais été aussi **facile**.

`\end{center}`{=latex}



## La révolution Python

`\begin{center}`{=latex}


Mais d'un autre côté, PyTorch et TensorFlow ont aussi `\defi{\textbf{biaisé}}`{=latex}la recherche \
vers un **petit nombre** d'opérations **bien supportées** : \
convolutions et produits matrice-matrice. `\\~`{=latex}
 

Ce focus n'est **pas** la conséquence d'une limitation
intrinsèque des GPUs : \
notre matériel est parfaitement capable de **simuler** \
de vastes **environnements 3D** en temps réel ! `\\~`{=latex}


En tant que chercheurs, nous devons
travailler à `\solution{\textbf{ouvrir d'autres chemins.}}`{=latex} \
Permettre le développement d'une gamme d'outils **complète**, \
des méthodes convexes et **robustes** \
aux modèles de *deep learning* **expressifs**.

`\end{center}`{=latex}


## Notre contribution à la communauté

KeOps et GeomLoss sont :

- `\solution{\textbf{Rapides}}`{=latex}: 10 à 1,000 fois plus efficaces que des codes GPU standards.
- **Économes en mémoire** : $O(\text{N})$ et pas $O(\text{N}^2)$.
- **Versatiles**, avec une interface **transparente** : liberté !
- **Puissantes et bien documentées** : pensées pour la recherche. `\\~`{=latex}
- `\defi{\textbf{Lentes}}`{=latex}avec de **très grands vecteurs de *features*** en dimension $\text{D} > \text{100}$.


À venir cette année :

```{=latex}
\begin{itemize}
	\item[$\rightarrow$] \textbf{Méthodes d'approximation} (Nyström, etc.) dans KeOps.
	\item[$\rightarrow$] Support optimal des \textbf{barycentres} et des \textbf{images} dans GeomLoss. 
\end{itemize}
```


## Un projet en pleine évolution

```{=latex}
\begin{adjustwidth}{.5cm}{.2cm}
\begin{itemize}
	\setlength\itemsep{.8em}
	\item[2017--18] \defi{Preuve de concept}avec articles de conférences et codes en ligne.\\
						Premiers retours de la communauté.

	\item[2019--21] \contexte{Bibliothèque stable}avec des théorèmes solides et une API bien documentée.\\
						Backend KeOps pour des paquets de haut niveau. \\
						\textbf{100k+ téléchargements} sur pip, etc.

	\item[2021--22] \solution{Bibliothèque mûre}avec des articles d'application concrets.\\
						Fonctionne \emph{out-of-the-box} pour les étudiants et les ingénieurs.\\
						$\Longrightarrow~~$ Refonte du moteur de compilation de KeOps pour la v1.6.\\
						$\Longrightarrow~~$ GeomLoss comme backend pour POT v1.0.

	\item[2022+] \textbf{Une bibliothèque standard} avec de réelles applications cliniques ?
					C'est l'objectif !
\end{itemize} 
\end{adjustwidth}
```


# Conclusion

## Points clés

- Les matrices `\solution{symboliques}`{=latex}sont au ML **géométrique** ce que \
  les matrices **creuses** sont au traitement de **graphes** : \
  $\longrightarrow~~$ KeOps: **accélération x30** vs. PyTorch, TF et JAX. \
  $\longrightarrow~~$ Utiles pour de nombreux problèmes. \
  \
- Transport optimal = `\solution{tri généralisé}`{=latex} : \
  $\longrightarrow~~$ Appariement géométrique. \
  $\longrightarrow~~$ Solveurs très rapides en $O(\text{N}\log \text{N})$.\
  \
- Ces outils ouvrent de **nouveaux chemins** pour les géomètres et les statisticiens : \
  $\longrightarrow~~$ Les GPUs sont plus **versatiles** qu'on ne le croit. \
  $\longrightarrow~~$ Travail constant sur les **fondations numériques** de la recherche, \
  $\phantom{\longrightarrow}~~~$ au-delà de ce pourquoi Google et Facebook sont prêts à payer. \


## Conclusion 

**KeOps** et **GeomLoss** stimulent la recherche sur :

- Les méthodes de **clustering** :  K-Means et EM rapides.
- La **représentation** des données : UMAP, KNN rapides avec n'importe quelle métrique.
- Les méthodes à `\solution{noyaux}`{=latex}: matrices de noyaux.
- Les **processus Gaussiens** : matrices de covariances. `\\~`{=latex}
- Le `\solution{\emph{deep learning} géométrique}`{=latex}: convolutions sur les points.
- L'imagerie **médicale** : anatomie computationnelle.
- Les **statistiques géométriques** : au-delà des modèles Euclidiens.
- Le traitement du **langage** : *transformers* efficaces ?

`\begin{center}\vspace*{.3cm}`{=latex}
Qu'en pensez-vous ?
`\end{center}`{=latex}


## Notre documentation et de nombreux tutoriaux sont disponibles en ligne

```{=latex}
\begin{center}
$\Longrightarrow$\qquad \url{www.kernel-operations.io}\qquad $\Longleftarrow$
\vspace*{.15cm}

\includegraphics[width=.5\linewidth,frame]{images/geometric_data_analysis.png}

%\vspace*{.15cm}

\url{www.jeanfeydy.com/geometric_data_analysis.pdf}
\end{center}

```






`\appendix`{=latex}

# Annexe


