import imageio
import numpy as np
from numpy.fft import fft2, ifft2
import scipy.misc

name = 'heart_raw.png'
M = imageio.imread(name).astype("float") / (3*255)
M = M[:,:,0] + M[:,:,1] + M[:,:,2]

filters = [
    np.array( [
        [0.,0.,0.,0.,0.],
        [0.,0.,0.,0.,0.],
        [0.,0.,1.,0.,0.],
        [0.,0.,0.,0.,0.],
        [0.,0.,0.,0.,0.],
    ]),
    np.array( [
        [0.,0.,0.,0.,0.],
        [0.,0.,.5,0.,0.],
        [0.,.5,1.,.5,0.],
        [0.,0.,.5,0.,0.],
        [0.,0.,0.,0.,0.],
    ]),
    np.array( [
        [0.,.1,.2,.1,0.],
        [.1,.3,.5,.2,.1],
        [.2,.5,1.,.5,.2],
        [.1,.3,.5,.3,.1],
        [0.,.1,.2,.1,0.],
    ]) ,
    np.array( [
        [0.,.7,.8,.7,0.],
        [.7,1.,1.,1.,.7],
        [.8,1.,1.,1.,.8],
        [.7,1.,1.,1.,.7],
        [0.,.7,.8,.7,0.],
    ]),
    np.array( [
        [0.,0.,0.,0.,0.],
        [0.,0.,0.,0.,0.],
        [0.,-1,0.,1,0.],
        [0.,0.,0.,0.,0.],
        [0.,0.,0.,0.,0.],
    ]),
    np.array( [
        [0.,0.,0.,0.,0.],
        [0.,0.,0.,0.,0.],
        [0.,-1,0.,1,0.],
        [0.,0.,0.,0.,0.],
        [0.,0.,0.,0.,0.],
    ]),
    np.array( [
        [0.,0.,0.,0.,0.],
        [0.,0.,1.,0.,0.],
        [0.,0.,0.,0.,0.],
        [0.,0.,-1.,0.,0.],
        [0.,0.,0.,0.,0.],
    ]),
    np.array( [
        [0.,0.,0.,0.,0.],
        [0.,0.,0.,1,0.],
        [0.,0.,0.,0.,0.],
        [0.,-1,0.,0.,0.],
        [0.,0.,0.,0.,0.],
    ]),
    np.array( [
        [0.,0.,0.,0.,0.],
        [0.,-1,0.,0.,0.],
        [0.,0.,0.,0.,0.],
        [0.,0.,0.,1,0.],
        [0.,0.,0.,0.,0.],
    ]),
]

for (it, h_) in enumerate(filters) :
    h = np.zeros( M.shape )
    h[-2:,-2:] = h_[:2,:2]
    h[-2:,:3]  = h_[:2,2:5]
    h[:3,-2:]  = h_[2:5,:2]
    h[:3,:3]   = h_[2:5,2:5]
    
    H = h if it > 3 else h / np.sum(h)
    MH = np.real( ifft2(fft2(M) * fft2(H)) )

    scipy.misc.toimage((h_+1)/2, cmin=0., cmax=1.).save('output_convolution/filter_'+str(it+1)+'.png')
    if it == 4 :
        scipy.misc.toimage((MH[5:-5,5:-5]+1)/2, cmin=0., cmax=1.).save('output_convolution/filtered_'+str(it+1)+'.png')
    elif it > 4 :
        scipy.misc.toimage(np.abs(MH[5:-5,5:-5]), cmin=0., cmax=.5).save('output_convolution/filtered_'+str(it+1)+'.png')
    else :
        scipy.misc.toimage(MH[5:-5,5:-5], cmin=0., cmax=1.).save('output_convolution/filtered_'+str(it+1)+'.png')


