import numpy as np 
import itertools

import os
from model_fitting import FitModel
import matplotlib
from matplotlib import pyplot as plt
import matplotlib.font_manager as fm
myfont = fm.FontProperties(fname='./Overlock-Regular.ttf')
#plt.rcParams["font.family"] = prop

plt.ion() 
plt.show() 


cmap  = plt.cm.bwr
cnorm = matplotlib.colors.Normalize(vmin=-1, vmax=1)
csm   = matplotlib.cm.ScalarMappable(cmap=cmap, norm=cnorm)

def arrow(ax, x1,x2, y1,y2, color='k', lw = 2, weight=None) :
    if weight is None :
        ax.arrow(x1, y1, x2-x1, y2-y1, fc=color, ec=color, lw = lw, 
                    head_width=.1, head_length=.1, overhang = .2, 
                    length_includes_head= True, clip_on = False)
    else :
        size = min(np.abs(weight), 1)
        color = csm.to_rgba(weight, alpha = (.3+size)/1.3)
        ax.arrow(x1, y1, x2-x1, y2-y1, fc=color, ec=color, lw = 1+2*size, 
                    head_width=0., head_length=.1, overhang = .2, 
                    length_includes_head= True, clip_on = False)

def node( name, ax, x, y, radius=.25, color="k" ) :
    circle = plt.Circle( (x,y), radius, color=color, fill=False, lw=2, zorder=3)
    ax.add_artist(circle)
    ax.text(x, y,  name, horizontalalignment='center', verticalalignment='center',
                         fontproperties = myfont, fontsize=25, color=color)



fig_model = plt.figure(1, figsize=(20,20), dpi=100)
ax  = fig_model.add_axes((0,0,1,1))
ax.set_axis_off()

fig_model.set_size_inches(12,3)


ax.clear()

ax.text(.5, 1.65,  "entrée", fontproperties = myfont, fontsize=25)
ax.text(10.5, 1.65,  "sortie", fontproperties = myfont, fontsize=25)

arrow( ax, 1.,1.75, 1.5,1.5)
node(  r'$\mathregular{x}$', ax, 2., 1.5, color="#080899")
node(  r'$\mathregular{j}$', ax, 6., 1.5, color="#990899")
node(  r'$\mathregular{y}$', ax, 10., 1.5, color="#990808")

arrow( ax, 10.25,11., 1.5,1.5)
arrow( ax, 2.25,5.75, 1.5,1.5, color="#0808C0")
arrow( ax, 6.25,9.75, 1.5,1.5, color="#C00808")
ax.text(4, 1.65,  "JPEG 2000", color="#0808C0" ,horizontalalignment='center', fontproperties = myfont, fontsize=25)
ax.text(8, 1.65,  "Régression linéaire", color="#C00808",horizontalalignment='center', fontproperties = myfont, fontsize=25)

ax.text(0., .8,  "Paramètres :", fontproperties = myfont, fontsize=25)
ax.text(4, .8,  "$\emptyset$", color="#0808C0" ,horizontalalignment='center', fontproperties = myfont, fontsize=25)
ax.text(8, .8,  "a , b", color="#C00808",horizontalalignment='center', fontproperties = myfont, fontsize=25)


ax.axis([0,12,-.5,2.5]) ; ax.set_aspect('equal') ; 
ax.axis('off')

plt.draw() ; plt.pause(0.01)

screenshot_filename = "output_processing/classical.png"
os.makedirs(os.path.dirname(screenshot_filename), exist_ok=True)
fig_model.savefig( screenshot_filename, bbox_inches='tight', transparent=True)






fig_model = plt.figure(2, figsize=(20,20), dpi=100)
ax  = fig_model.add_axes((0,0,1,1))
ax.set_axis_off()

fig_model.set_size_inches(12,3)


ax.clear()

ax.text(.5, 1.65,  "entrée", fontproperties = myfont, fontsize=25)
ax.text(10.5, 1.65,  "sortie", fontproperties = myfont, fontsize=25)

arrow( ax, 1.,1.75, 1.5,1.5)
node(  r'$\mathregular{x}$', ax, 2., 1.5, color="#080899")
node(  r'$\mathregular{j}$', ax, 6., 1.5, color="#990899")
node(  r'$\mathregular{y}$', ax, 10., 1.5, color="#990808")

arrow( ax, 10.25,11., 1.5,1.5)
arrow( ax, 2.25,5.75, 1.5,1.5, color="#0808C0")
arrow( ax, 6.25,9.75, 1.5,1.5, color="#C00808")
ax.text(4, 1.65,  "«JPEG 2020»", color="#0808C0" ,horizontalalignment='center', fontproperties = myfont, fontsize=25)
ax.text(8, 1.65,  "Régression linéaire", color="#C00808",horizontalalignment='center', fontproperties = myfont, fontsize=25)

ax.text(0., .8,  "Paramètres :", fontproperties = myfont, fontsize=25)
ax.text(4, .8,  "$\mathregular{φ_1  , φ_2  , ...}$", color="#0808C0" ,horizontalalignment='center', fontproperties = myfont, fontsize=25)
ax.text(8, .8,  "a , b", color="#C00808",horizontalalignment='center', fontproperties = myfont, fontsize=25)


ax.axis([0,12,-.5,2.5]) ; ax.set_aspect('equal') ; 
ax.axis('off')

plt.draw() ; plt.pause(0.01)

screenshot_filename = "output_processing/modern.png"
os.makedirs(os.path.dirname(screenshot_filename), exist_ok=True)
fig_model.savefig( screenshot_filename, bbox_inches='tight', transparent=True)


plt.show(block=True)

